/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.AnimatedGifEncoder;
import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2i;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNImageUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class OEImageUtils {
    public static byte[] reductionSize(byte[] data, long size) throws IOException {
        long lastSize = data.length;
        if (lastSize <= size) {
            return data;
        }
        GifDecoder decoder = new GifDecoder();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            if (decoder.read(stream) != 0) {
                byte[] byArray = FNImageUtil.toByteArray(FNImageUtil.reductionSize(ImageIO.read(new ByteArrayInputStream(data)), size), "png");
                return byArray;
            }
        }
        float scale = (float)size / (float)lastSize;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            int i;
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            encoder.start(stream);
            encoder.setRepeat(0);
            FNVec2i siz = null;
            for (i = 0; i < decoder.getFrameCount(); ++i) {
                BufferedImage fb = decoder.getFrame(i);
                byte[] le = FNImageUtil.toByteArray(fb, "png");
                BufferedImage img = FNImageUtil.reductionSize(fb, (long)((float)le.length * scale));
                if (siz == null) {
                    siz = new FNVec2i(img.getWidth(), img.getHeight());
                    continue;
                }
                if (siz.getX() <= img.getWidth() || siz.getY() <= img.getHeight()) continue;
                siz = new FNVec2i(img.getWidth(), img.getHeight());
            }
            if (siz != null) {
                for (i = 0; i < decoder.getFrameCount(); ++i) {
                    encoder.setDelay(decoder.getDelay(i));
                    encoder.addFrame(FNImageUtil.resize(decoder.getFrame(i), siz.getX(), siz.getY()));
                }
            }
            encoder.finish();
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    public static boolean isImage(byte[] data) {
        return OEImageUtils.isGif(data) || FNImageUtil.isImage(data);
    }

    public static boolean isGif(byte[] data) {
        boolean bl;
        GifDecoder decoder = new GifDecoder();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        try {
            bl = decoder.read(stream) == 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }
}

